##########################################################################################
########################################## INFO ##########################################
##########################################################################################

"""
This program is provided during session 2 of the PyRat project:
https://hub.imt-atlantique.fr/ueinfo-fise1a/s5/project/session2/practical/
"""

##########################################################################################
######################################### IMPORTS ########################################
##########################################################################################

# PyRat imports
from utils.Traversal import Traversal

##########################################################################################
######################################### CLASSES ########################################
##########################################################################################

class BFSTraversal (Traversal):

    """
    This class implements a breadth-first search (BFS) traversal algorithm by defining the abstract methods from the parent class.
    We use a FIFO queue to indicate the order in which vertices should be explored.
    """

    ##################################################################################
    #                                   CONSTRUCTOR                                  #
    ##################################################################################

    def __init__ ( self,
                   *args:    object,
                   **kwargs: object
                 ) ->        None:

        """
        *(This class inherits from* ``Traversal`` *).*

        It implements a breadth-first search (BFS) traversal algorithm by defining the abstract methods from the parent class.
        We use a FIFO queue to indicate the order in which vertices should be explored.

        Args:
            args:   Arguments to pass to the parent constructor.
            kwargs: Keyword arguments to pass to the parent constructor.
        """
        
        # Inherit from parent class
        super().__init__(*args, **kwargs)

    ##################################################################################
    #                                     METHODS                                    #
    ##################################################################################

    def initialize_structure (self) -> object:
    
        """
        *(This method redefines the method of the parent class with the same name).*

        It initializes the data structure needed for the traversal.
        Here, we use a list to implement a FIFO queue.

        Returns:
            The initialized data structure.
        """

        # We return an empty list
        return []

    ##################################################################################

    def add_to_structure ( self,
                           structure: object,
                           element:   object
                         ) ->         object:
    
        """
        *(This method redefines the method of the parent class with the same name).*

        It adds an element to the data structure and returns the updated data structure.
        Here, we append the element to the end of the list to implement a FIFO queue.

        Returns:
            The updated data structure.
        """

        # We append the element to the end of the list
        structure.append(element)
        return structure

    ##################################################################################

    def get_from_structure ( self,
                             structure: object,
                           ) ->         tuple[object, object]:

        """
        *(This method is abstract and must be implemented in the subclasses).*

        It extracts an element from the data structure and returns it along with the updated data structure.
        Here, we remove and return the first element of the list to implement a FIFO queue.

        Returns:
            A tuple containing the extracted element and the updated data structure.
        """

        # We remove and return the first element of the list
        element = structure.pop(0)
        return element, structure

##########################################################################################
##########################################################################################
